/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.registry;

import com.simibubi.create.foundation.damageTypes.DamageTypeBuilder;
import io.github.jasonsimpart.createdelightcore.CreateDelightCore;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class CDCDamageTypes {
    public static final ResourceKey<DamageType> MOLTEN_METAL = CDCDamageTypes.key("molten_metal");
    public static final ResourceKey<DamageType> ICE_CREAM = CDCDamageTypes.key("ice_cream");
    public static final ResourceKey<DamageType> RADIATION = CDCDamageTypes.key("radiation");

    private static ResourceKey<DamageType> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)CreateDelightCore.id(name));
    }

    public static void bootstrap(BootstapContext<DamageType> ctx) {
        new DamageTypeBuilder(ICE_CREAM).scaling(DamageScaling.ALWAYS).effects(DamageEffects.FREEZING).register(ctx);
        new DamageTypeBuilder(MOLTEN_METAL).scaling(DamageScaling.ALWAYS).effects(DamageEffects.BURNING).register(ctx);
        new DamageTypeBuilder(RADIATION).scaling(DamageScaling.ALWAYS).effects(DamageEffects.BURNING).register(ctx);
    }

    private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)registry.m_246971_(key));
    }

    public static DamageSource moltenMetal(Level level) {
        return CDCDamageTypes.source(MOLTEN_METAL, (LevelReader)level);
    }

    public static DamageSource iceCream(Level level) {
        return CDCDamageTypes.source(ICE_CREAM, (LevelReader)level);
    }

    public static DamageSource radiation(Level level) {
        return CDCDamageTypes.source(RADIATION, (LevelReader)level);
    }
}

